from tkinter import *

window = Tk()
window.title("Miles to Km Converter")
window.config(padx=60, pady=20)

miles_input = Entry(width=5)
miles_input.grid(column=2,row=1)

miles_label = Label(text="Miles")
miles_label.grid(column=3,row=1)

equal_label = Label(text="is equal to")
equal_label.grid(column=0,row=2)

result = Label(text="0")
result.grid(column=2,row=2)

kms_label = Label(text="Km")
kms_label.grid(column=3,row=2)

def convert():
    try:
        miles=float(miles_input.get())
        kms = round(miles*1.609344,2)
    except ValueError:
        kms=0
    result.config(text=f"{kms}")

calculate = Button(text="Calculate",command=convert)
calculate.grid(column=2,row=3)

window.mainloop()